***************************************************************
*
*   Layout Module:
*
*          Copyright 1989, 1990
*          Simple Software Systems International, Inc.
*
*          ALL RIGHTS RESERVED
*
* Marc Wolfgram,  30Mar89
*
*****************************************************************
*
           case     on

           copy     2/ainclude/e16.types
           copy     2/ainclude/e16.control
           copy     2/ainclude/e16.event
           copy     2/ainclude/e16.memory
           copy     2/ainclude/e16.intmath
           copy     2/ainclude/e16.window

           copy     e16.genesys

           mcopy    layout.mac

ShowCoord  START
*****************************************************************
* ShowCoord
* ClearCoord
* ShellCoords
* DrawCoords
* Reset Origin
* Set Origin
*
*   Inputs:
*
*   Outputs:
*
*****************************************************************
*
           using Shell

           lda      SMURF+EditModifiers       See if coords are on
           and      #modCoordOn
           bne      TCoord00            Yes, turn it off

           lda      SMURF+EditModifiers
           ora      #modCoordOn
           sta      SMURF+EditModifiers

           PushLong #MHCstr
           PushWord #265
           _SetMItemName
           ldx      #$8002
           jsl      shError2

           lda      #0
           rtl

TCoord00   lda      SMURF+EditModifiers
           eor      #modCoordOn
           sta      SMURF+EditModifiers

           PushLong #MSCstr
           PushWord #265
           _SetMItemName
           ldx      #$8004
           jsl      shError2

ClearCoord ENTRY

           PushLong #0
           _GetPort                       Long left on stack

           PushLong #0
           _GetMenuMgrPort
           _SetPort

           PushWord #0
           _GetTextMode                   Word on stack

           PushWord #15
           _SetBackColor
           PushWord #0
           _SetForeColor
           PushWord #0
           _SetTextMode

           PushWord #480
           PushWord #10
           _MoveTo
           PushLong #CLR_STR
           _DrawString

           _SetTextMode
           _SetPort

           lda      #0
           rtl

ShellCoords ENTRY

           phb
           phd
           phk
           plb

           lda      SMURF+EditModifiers
           and      #modCoordOn
           beq      ShellExit

           PushLong #0
           _GetPort                     Long left on stack

           PushLong #0
           _GetWMgrPort
           _SetPort

           PushLong #Pt
           _GetMouse
           _SetPort

           sec                          |
           lda   Pt+2                   |
           sbc   SMURF+GridOrigin+2     |
           pha                          | 1.01: moved offset calc from start of
           sec                          |       DrawCoords call
           lda   Pt                     |
           sbc   SMURF+GridOrigin       |
           pha                          |
           jsl      DrawCoords

ShellExit  pld
           plb
           rtl

DrawCoords ENTRY

           phd                          Plus 2
           phb                          Plus 1
           phk
           plb

           lda      SMURF+EditModifiers
           and      #modCoordOn
           bne      CoordsOn
           brl      CoordsOff

CoordsOn   PushLong #0
           _GetPort                     Long left on stack

           lda   11,s                   DrawCoords call
           sta   Pt
           lda   13,s
           sta   Pt+2

           PushLong #0
           _GetMenuMgrPort
           ldx      #$8102
           jsl      shError2
           _SetPort

           PushWord #0
           _GetTextMode                   Word on stack

           PushWord #15
           _SetBackColor
           PushWord #0
           _SetForeColor
           PushWord #0
           _SetTextMode

           PushWord Pt
           PushLong #VPT_STR+6
           PushWord #4
           PushWord #1
           _Int2Dec
           ldx      #$8110
           jsl      shError2

           PushWord Pt+2
           PushLong #HPT_STR+6
           PushWord #4
           PushWord #1
           _Int2Dec
           ldx      #$8111
           jsl      shError2

           PushWord #480
           PushWord #10
           _MoveTo
           PushLong #HPT_STR
           _DrawString

           PushWord #552
           PushWord #10
           _MoveTo
           PushLong #VPT_STR
           _DrawString

           _SetTextMode
           _SetPort

CoordsOff  anop
*- A neat stack hack 10 byte rtl move - AB S234567890
           lda      5,s                 tl:bdprtlpvph
           sta      9,s                 tl:bdprtlpvtl
           plb                          rt:dprtlpvtl.
           pld                          rt:rtlpvtl...
           pla                          rt:lpvtl.....
           sta      3,s                 rt:lprtl.....
           pla                          lp:rtl.......

           rtl

ResetOrigin ENTRY

           stz      SMURF+GridOrigin          Zero out the vertical and
           stz      SMURF+GridOrigin+2          horizontal grid offsets

           lda      #0                  No possible errors

           rtl

SetOrigin ENTRY

           lda      SMURF+EditModifiers Make sur coordinates are on
           pha                            o
           ora      #modCoordOn           o
           sta      SMURF+EditModifiers   o

           stz      SMURF+GridOrigin    All offsets based on 0,0
           stz      SMURF+GridOrigin+2

           PushLong #GridCursor         Put up our cross hairs
           _setCursor

loop       jsl      ShellCoords          Now wait for a button down!
           PushWord #0                    o
           PushWord #0                    o
           _Button                        o
           pla
           beq      loop                Not yet so do more!

           lda      Pt                  Reset offset
           sta      SMURF+GridOrigin      o
           lda      Pt+2                  o
           sta      SMURF+GridOrigin+2    o

           _InitCursor                  Reset pointer cursor

           pla                          Reset Cusor status
           sta      SMURF+EditModifiers
           and      #modCoordOn
           beq      ClearLine

           lda      #0
           rtl

ClearLine  jmp      ClearCoord

Pt         ds       4

MSCstr     str      'Show Coordinates'
MHCstr     str      'Hide Coordinates'

MSRstr     str      'Show Rulers'
MHRstr     str      'Hide Rulers'

MSGstr     str      'Show Grid'
MHGstr     str      'Hide Grid'

HPT_STR    str      'H =         '
VPT_STR    str      'V =         '

CLR_STR    str      '                                  '

GridCursor dc       I'11,4'

           dc       h'00000F0000000000'
           dc       h'0000FFF000000000'
           dc       h'000F0F0F00000000'
           dc       h'00F00F00F0000000'
           dc       h'0F000F000F000000'
           dc       h'FFFFF0FFFFF00000'
           dc       h'0F000F000F000000'
           dc       h'00F00F00F0000000'
           dc       h'000F0F0F00000000'
           dc       h'0000FFF000000000'
           dc       h'00000F0000000000'

           dc       h'00000F0000000000'
           dc       h'0000FFF000000000'
           dc       h'000F0F0F00000000'
           dc       h'00F00F00F0000000'
           dc       h'0F000F000F000000'
           dc       h'FFFFFFFFFFF00000'
           dc       h'0F000F000F000000'
           dc       h'00F00F00F0000000'
           dc       h'000F0F0F00000000'
           dc       h'0000FFF000000000'
           dc       h'00000F0000000000'

           dc       i2'5,11'

         END

DoShowRoot START
*****************************************************************
*
*   DoHideRoot
*   DoShowRoot
*
*****************************************************************
*
           PushWord #1                  We want to show the window if hidden.
           PushLong RootWPtr            NOTE: Does not change Front to Back...
           _ShowHide                    ordering or generate activate events.
           ldx      #$8502
           jsl      shError2

           PushLong RootWPtr            Brings the window to front, hilites it,
           _SelectWindow                and generates activate events.
           ldx      #$8503
           jsl      shError2

           PushWord #HRootID            276
           _EnableMItem
           ldx      #$8504
           jsl      shError2

           lda      SMURF+EditModifiers
           and      #$ffbf

           bra      doRootExit

DoHideRoot ENTRY

           PushLong RootWPtr
           _HideWindow
           ldx      #$8506
           jsl      shError2

           PushWord #HRootID            276
           _DisableMItem
           ldx      #$8508
           jsl      shError2

           lda      SMURF+EditModifiers
           ora      #modRWHide
doRootExit sta      SMURF+EditModifiers

           lda      #0
           rtl

           END

doNextWindow  START
*****************************************************************
*
*   doNextWindow sends the front window to the back of the bus...
*
*   Marc 2Jan90
*
*****************************************************************
*
           PushLong #-2
           PushLong #0
           _FrontWindow
           ldx      #$8602
           jsl      shError2
           lda      1,s
           ora      3,s
           bne      haveWin
           pla
           pla
           pla
           pla
           bra      endNext

haveWin    _SendBehind
           ldx      #$8603
           jsl      shError2

endNext    lda      #0
           RTL
           END

ChkAlreadyEdit START
*****************************************************************
*
*****************************************************************
*
           using    Shell

           PushWord #0                  Preloaded result space for _GetSysWFlag

           PushLong #0                  Get frontmost window result
           _FrontWindow                 Get the front window
           ldx      #$8802
           jsl      shError2
           lda      1,s                 Set TempWin, don't hurt the stack!
           sta      TempWin               o
           lda      3,s                   o
           sta      TempWin+2             o

ChkSys     _GetSysWFlag                 Check for NDA window (stack setup ok)
           pla                            o

           bne      NextWind            BR = NDA, we're outa here!

           lda      TempWin             see if the root window
           cmp      RootWPtr            root window?
           bne      GetRefCon           BR = not root, must be editor
           lda      TempWin+2           compare, check hi word
           cmp      RootWPtr+2
           bne      GetRefCon           BR = not root, must be editor

NextWind   anop                         Is system window, so get next
           PushWord #0                  Preloaded result space for _GetSysWFlag
           PushLong #0
           PushLong TempWin
           _GetNextWindow
           ldx      #$8804
           jsl      shError2
           lda      1,s                 Set TempWin, don't hurt the stack!
           sta      TempWin               o
           lda      3,s                   o
           sta      TempWin+2             o
           ora      1,s                 Is the result nill
           bne      ChkSys              BR = another window, check if DA again

           pla                          window lo
           pla                          window hi
           pla                          result space

           lda      #-1                 Flag Editor window not found
           rtl                          No more windows, we're outa here

NotOurs    jsr      FreeDP
           bra      NextWind

GetRefCon  PushLong #0                  Space for RefCon (handle to dispatch)
           PushLong TempWin
           _GetWRefCon                  get the window's refcon handle
           ldx      #$8806
           jsl      shError2
           jsr      GrabDP
           PullLong deref               set the refcon handle in deref

           ldy      #2                  get the refcon pointer from the handle
           lda      [deref],y             o
           tax                            o
           lda      [deref]               o
           sta      deref               set the refcon pointer in deref
           stx      deref+2

           ldy      #WinResType         Set offset for SMURF Resource Type
           lda      [deref],y           get the resource type from the refcon
           cmp      SMURF+ResourceType
           bne      NotOurs             BR = no, find next window

           ldy      #WinResID           Set SMURF Resource ID
           lda      [deref],y           likewise for the resource id
           cmp      SMURF+ResourceID
           bne      NotOurs             BR = no, find next window
           iny
           iny
           lda      [deref],y
           cmp      SMURF+ResourceID+2
           bne      NotOurs            BR = no, find next window

           jsr      FreeDP

* WE GET GERE IF WE'VE GOT AN EDITOR WINDOW OPEN THAT MATCHES THE SMURF'S
* RESOURCE ID AND RESOURCE TYPE!

           PushWord #1                  We want to show the window if hidden.
           PushLong TempWin             NOTE: Does not change Front to Back...
           _ShowHide                    ordering or generate activate events.
           ldx      #$8808
           jsl      shError2

           PushLong TempWin             Brings the window to front, hilites it,
           _SelectWindow                and generates activate events.
           ldx      #$880A
           jsl      shError2

           LDA      #0                  Zero, Found one so DON'T Dispatch Editor

           RTL

TempWin    ds 4

           END

CloseFileMenuHi START
*****************************************************************
*
*   CloseFileMenuHi - hilites menus when closing root window
*
*****************************************************************
*
           using    Shell

           phb
           phd
           phk
           plb

           PushLong #IdleMenuList
           PushWord #-1                 Enable
           jsl      SetMenus

           PushLong #LiveMenuList
           PushWord #0                  Disable
           jsl      SetMenus

           pld
           plb
ChkEdMenu  ENTRY
           phb
           phd
           phk
           plb

           PushLong #0                  Get frontmost window
           _FrontWindow
           ldx      #$8902
           jsl      shError2
           pla                          window lo
           ora      1,S
           beq      DehiEd
           lda      #-1

DehiEd     cmp      EdState
           beq      EdDone
           sta      EdState
           PushLong #EditMenuList
           PushWord EdState
           jsl      SetMenus

EdDone     pla                          window hi
           pld
           plb
           lda      #0
           RTL

EdState    dc       i2'-1'

SetMenus   ENTRY
           phd                          SP>dpRTLfwmptr
           tsc                             123456789AB
           pha
           pld

           ldy      #0
smLoop     lda      [8],y
           beq      smDone

           iny
           iny
           phy
           pha

           lda      6
           beq      smDehi

           _EnableMItem
           ldx      #$8980
           jsl      shError2
           ply
           bra      smLoop

smDehi     _DisableMItem
           ldx      #$8981
           jsl      shError2
           ply
           bra      smLoop

smDone     pld                          SP>RTLfwmptr
           lda      2,s                    123456789
           sta      8,s                    RTLfwmpTL
           pla                             LfwmpTL
           sta      5,s                    LfwmRTL
           pla                             wmRTL
           pla                             RTL
           lda      #0
           clc
           rtl

CheckHide  ENTRY
           phb
           phk
           plb

           lda      SMURF+EditModifiers
           and      #modRWHide
           beq      chkOut

           PushWord #HRootID
           _DisableMItem
           ldx      #$8983
           jsl      shError2

chkOut     plb                             RTL
           rtl

           END

ChkLastEd  START
*****************************************************************
*
*  ChkLastEd
*
*****************************************************************
*
           using    Shell

           phb
           phd
           phk
           plb

           lda      SMURF+EditModifiers
           and      #modRWHide
           beq      chkExit             br = not hidden

           PushLong #0
           _GetFirstWindow
           ldx      #$8A02
           jsl      shError2

editorWalk pla
           sta      tempW
           pla
           sta      tempW+2
           ora      tempW
           bne      chkRefCon           br = valid window

           jsl      DoShowRoot          else no editor windows...
           bra      chkExit             done

chkRefCon  PushLong tempW
           jsl      RefConSetup
           lda      SMURF+ResourceType  Is the front window an editors?
           bne      chkExit             br = editor

           PushLong #0
           PushLong tempW
           _GetNextWindow
           ldx      #$8A04
           jsl      shError2
           bra      editorWalk

chkExit    lda      #0
           pld
           plb
           RTL

tempW      ds 4

           END

FindEdWin  START
*****************************************************************
*
*  FindEdWin
*
*  on entry rType and rID are on the stack
*
*  on exit a/x contain a null pointer if the editor was not found
*  or a pointer to the open window.  Side effect: SMURF is setup.
*****************************************************************
*
           using    Shell

           phb
           phd
           phk                            123456789012
           plb                            dpbRTLrtritm

           PushLong #0
           _GetFirstWindow
           ldx      #$8B02
           jsl      shError2
           bra      findEdWalk

findEdNext PushLong #0
           PushLong tempW
           _GetNextWindow
           ldx      #$8B04
           jsl      shError2

findEdWalk pla
           sta      tempW
           pla
           sta      tempW+2
           ora      tempW
           beq      findEdExit

           PushLong tempW
           jsl      RefConSetup
           lda      SMURF+ResourceType
           cmp      7,s
           bne      findEdNext
           lda      SMURF+ResourceID
           cmp      9,s
           bne      findEdNext
           lda      SMURF+ResourceID+2
           cmp      11,s
           bne      findEdNext

findEdExit ldy      tempW                  123456789012
           ldx      tempW+2                dpbRTLrtritm
           pld                             bRTLrtritm
           pla                          bR TLrtritm
           sta      5,s                    TLrtbRtm
           pla                          TL rtbRtm
           sta      5,s                    rtbRTL
           pla                             bRTL
           plb                             RTL
           tya

           RTL

tempW      ds 4

           END

; _______________________________________________
;|                                               |
;| shError(toolerror(), loc) - show error dialog |
;| On stack:        location info                |
;|                  error number                 |
;|                                               |
;| shError2 - show error dialog based on A and X |
;| In registers: X  location info                |
;|               A  error number                 |
;|                                               |
;| 06Jun90                                       |
;| 01/17/89 09:30                                |
;|_______________________________________________|

shError   start

;_Stack/Direct Page offsets______________________

OrigD      equ      1                   0
OrigB      equ      OrigD+2             2
RtnAddr    equ      OrigB+1             3
errorNum   equ      RtnAddr+3           6  A
errorLoc   equ      errorNum+2          8  X

           phb
           phd
           phk
           plb

           tsc
           tcd                          ; align stack and DP

           lda      errorNum

           bne      doTheError
           brl      deOut

doTheError anop

           ldx      errorLoc
           phx
           pha

           PushLong #ErrStr
           PushWord #4
           _Int2Hex

           PushLong #WhereStr
           PushWord #4
           _Int2Hex

           pha
           PushLong #AlertTmplt
           PushLong #0000
           _StopAlert
           pla

deOut      anop

           lda      <RtnAddr            ; move return address up
           sta      <errorLoc-1
           lda      <RtnAddr+1
           sta      <errorLoc

           tsc                          ; get stack pointer

           pld                          ; restore data bank register
           plb                          ; restore direct page register

           clc                          ; adjust the stack pointer
           adc      #errorLoc-2
           tcs                          ; reset stack pointer

           rtl

shError2   entry

           cmp      #0
           bne      realError
           rtl

realError  phx
           pha
           jsl      shError
           rtl
;________________________________________________

AlertTmplt anop

           dc       I'30,120,80,520'
           dc       I'6666'
           dc       H'80'
           dc       H'80'
           dc       H'80'
           dc       H'80'
           dc       I4'Button'
           dc       I4'Message1'
           dc       I4'0000'

; ____________________________________________________________________

Button     anop

           dc       I2'1'
           dc       I2'31,150,44,250'   was 200
           dc       I2'$000A'
           dc       I4'ContName'
           dc       I2'00'
           dc       I2'00'
           dc       I4'0000'

ContName   anop

           STR      'Continue'

; ____________________________________________________________________

Message1   anop

           dc       I2'1348'
           dc       I2'06,72,200,640'
           dc       I2'$000F+$8000'
           dc       I4'Msg1'            ; descriptor
           dc       I2'00'              ; value
           dc       I2'00'              ; flag
           dc       I4'0000'            ; color

Msg1       anop

           dc       I1'EndMsg1-StartMsg1'

StartMsg1  anop

           dc       C'Error $'

ErrStr     anop

           ds       4
           dc       C' occured at $'

WhereStr   anop

           ds       4
           dc       C' in the Shell'
           dc       H'0D'

           dc       C'Please record and report this information.'
           dc       H'0D'

EndMsg1    anop

           end                          ; of shError

PaulElseth START    M_WOLFGRAM
*****************************************************************
*
*  PaulElseth - "End of the SMURF" command dispatcher...
*
*  Sidebar:  Paul did not have anything to do with this function.
*  Indeed, the label is an anachronism, however, he is a programmer
*  to be respected, and the SMURF location of the vector to this
*  function was the former PaulEProc, so I decided to keep this in
*  tribute to his contributions to the IIgs world.
*
*****************************************************************
*
           phb
           phd
           phk
           plb
           tsc
           tcd

* DPage:   0 1 2 3 4 5 6 7 8 9 A B C
* STACK:  | |dp |b| RTL | long  |cmd|
*
* param:  |siz|params...

           ldy      #2

           lda      11                  command
           asl      a
           tax                          pCount index
           lda      [7]                 pSize
           cmp      pCountTBL,x
           beq      ParamsSane

           _SysBeep
           ldx      #0
           lda      #0
*                                        1 2 3 4 5 6 7 8 9 A B C
vectorRTL  sta      7,s                 |dp |b| RTL |acc|       |
           pld                          |b| RTL |acc|       |
           pla                          :TL |acc|       |
           sta      5,s                 :TL |acc|b|R:   |
           pla                          |acc|b|R:   |
           sta      5,s                 |acc|b| RTL |
           pla                          |b| RTL |
           plb                          | RTL |
           RTL

ParamsSane cmp      #0
           beq      ParamsDone

           tay
PushParams lda      [7],y
           pha
           dey
           dey
           bne      PushParams

ParamsDone lda      11

           asl      A
           asl      A
           tax
           phk
           pea      vectorRTL-1
           SHORTM
           lda      commandTBL+2,x
           pha
           LONGM
           lda      commandTBL,x
           pha
           lda      2,s                 b/h
           pha
           plb                          h
           plb                          b :)
           RTL

commandTBL dc       i4'0'     ; routines in EOS.cc unless otherwise specified
           dc       i4'DrawCoords-1'    this file
           dc       i4'EOS_AntMarch-1'
           dc       i4'EOS_AddChild-1'
           dc       i4'EOS_Create2-1'
           dc       i4'0'               RESERVED
           dc       i4'EOS_Special-1'
           dc       i4'Dependents-1'
           dc       i4'EOS_Update-1'
           dc       i4'EOS_Res2Hand-1'
           dc       i4'0'               le2pstr
           dc       i4'EOS_LoadRes-1'
           dc       i4'EOS_SaveRes-1'
           dc       i4'EOS_AddRes-1'
           dc       i4'EOS_KillRes-1'
           dc       i4'EOS_CntrWin-1'  Misc.cc
           dc       i4'0'               cutcopy
           dc       i4'0'               subedit
           dc       i4'EOS_IndexChild-1'

pCountTBL  dc       i2'-1'
           dc       i2'4'
           dc       i2'10'
           dc       i2'6'
           dc       i2'10'
           dc       i2'-1'               ?
           dc       i2'6'
           dc       i2'12'
           dc       i2'8'
           dc       i2'8'
           dc       i2'-1'              14
           dc       i2'6'
           dc       i2'8'
           dc       i2'12'
           dc       i2'6'
           dc       i2'2'
           dc       i2'-1'               8
           dc       i2'-1'               8
           dc       i2'10'
           END
